function [hdr,img]=readAnalyze(filename)
%[hdr,img]=readAnalyze(filename)
%Read  Analyze files
%Input:
% filename: a filename with extension '.hdr' or '.img'.
%Output:
% hdr: headr structure
% img: intensity matrix
%
%20040318, jdlee
%20040429, jdlee

[path,name,ext] = fileparts(filename);
hdrFile = fullfile(path,[name '.hdr']);
imgFile = fullfile(path,[name '.img']);

rawhdr = readrawhdr(hdrFile);
Az.hdr = rawhdr2hdr(rawhdr);
Az.img = readimg(imgFile,Az.hdr);

hdr = Az.hdr;
img = Az.img;

return